/*
 * oc_leaf.h
 *
 * Created: 9/24/2019 3:28:46 PM
 *  ######################################################################################################
 *  DISCLAIMER:
 *  OptConnect Management, LLC provides this documentation in support of its products for the internal use
 *  of its current and prospective customers. The publication of this document does not create any other
 *  right or license in any party to use any content contained in or referred to in this document and any
 *  modification or redistribution of this document is not permitted. While efforts are made to ensure
 *  accuracy, typographical and other errors may exist in this document. OptConnect Management, LLC reserves
 *  the right to modify or discontinue its products and to modify this and any other product documentation
 *  at any time.
 * 
 *  All OptConnect products are sold subject to its published Terms and Conditions and subject to any
 *  separate terms agreed with its customers. No warranty of any type is extended by publication of this
 *  documentation, including, but not limited to, implied warranties of merchantability, fitness for a
 *  particular purpose and non-infringement.
 * 
 *  OptConnect is a trademark, and OptConnect ema is a trademark, of OptConnect Management, LLC. All
 *  trademarks, service marks and similar designations referenced in this document are the property of
 *  their respective owners
 *  #######################################################################################################
 * 
 *  version: 1.0
 * 
 *  History:
 *  Version     Description                                     Date
 *  1.0         Initial Release                                 5/19/2020
 */ 


#ifndef OC_LEAF_H_
#define OC_LEAF_H_

#include "oc_ema_modem_at.h"

//#define TASK_LEAF_STACK_SIZE (768 / sizeof(portSTACK_TYPE))
//#define TASK_LEAF_PRIORITY (tskIDLE_PRIORITY + 3)

#define LEAF_MAX_MESSAGE_SIZE 3000
#define LEAF_MESSAGE_QUEUE_SIZE 10000

#define LEAF_MODEM_COMMAND_TIMEOUT 2000
#define LEAF_MODEM_QUERY_TIMEOUT 2000
#define LEAF_MODEM_HTTP_POST_TIMEOUT 32000
#define LEAF_MODEM_HTTPRECV_TIMEOUT 2000
#define LEAF_MODEM_HTTPRING_TIMEOUT 5000

#define LEAF_MAX_COMMAND_PARAMS 10
#define LEAF_CMD_SIZE 96       

enum LeafMessageTypes {
    LEAF_STATISTIC = 0,
    LEAF_EVENT = 1,
    LEAF_NOOP = 2
};

int start_leaf( struct modem_at_context *context, unsigned char cntx_id,
                                                  char *leaf_device_id, 
                                                  char *leaf_host, 
                                                  char *realm, 
                                                  char *user, 
                                                  char *password );

int build_leaf_noop( void );
int build_leaf_message(int message_type, char *message_sub_type, char *data);
int send_leaf_query( struct modem_at_context *context, unsigned char cntx_id, int data_len, int *resp_code, char *leaf_cmd );

#endif /* OC_LEAF_H_ */