/*
 * emaPlay_config.h
 *
 * Created: 10/11/2019 10:01:32 AM
 *
 * oc_emaLink_at.c
 *
 * Created: 6/24/2019 11:49:48 AM
 * 
 *  ######################################################################################################
 *  DISCLAIMER:
 *  OptConnect Management, LLC provides this documentation in support of its products for the internal use
 *  of its current and prospective customers. The publication of this document does not create any other
 *  right or license in any party to use any content contained in or referred to in this document and any
 *  modification or redistribution of this document is not permitted. While efforts are made to ensure
 *  accuracy, typographical and other errors may exist in this document. OptConnect Management, LLC reserves
 *  the right to modify or discontinue its products and to modify this and any other product documentation
 *  at any time.
 * 
 *  All OptConnect products are sold subject to its published Terms and Conditions and subject to any
 *  separate terms agreed with its customers. No warranty of any type is extended by publication of this
 *  documentation, including, but not limited to, implied warranties of merchantability, fitness for a
 *  particular purpose and non-infringement.
 * 
 *  OptConnect is a trademark, and OptConnect ema is a trademark, of OptConnect Management, LLC. All
 *  trademarks, service marks and similar designations referenced in this document are the property of
 *  their respective owners
 *  #######################################################################################################
 * 
 *  version: 1.0
 * 
 *  History:
 *  Version     Description                                     Date
 *  1.0         Initial Release                                 5/19/2020
 */ 

#ifndef EMAPLAY_CONFIG_H_
#define EMAPLAY_CONFIG_H_

#define ENABLE_LEAF_NOOP                1       // 1 = send leaf noop to get data from the server synchronously(higher system latency) 
                                                // 0 = use ema Board Notify to get data from the server asynchronously(not supported)
#define LEAF_ATTEMPTS                   1       // number of attempts for a leaf query(if a failure occurs)
#define DIN_D_TIME                      2000    // ms. Digital input debounce time

#ifdef DEBUG
    // function specific console debug control
    #define     DBG_MODEM_AT                0       // console output of ema Modem UART interface traffic
    #define     DBG_MODEM_AT_HEX            0       // console output of ema Modem UART interface traffic in hex format
    #define     DBG_EMA_LINK_AT             0       // console output of ema Management UART interface traffic
    #define     DBG_EMA_LINK_AT_HEX         0       // console output of ema Management UART interface traffic in hex format
    #define     DBG_EMA_LINK_URC            0       // console output of ema URCs
    #define     DBG_EMA_LINK_URC_HEX        0       // console output of ema URC hex format
    #define     DBG_APPLICATION             1       // console output of ema main application debug messsages
#endif

// functionality    
#define     OPT_RECOVER_EMA             1       // 1 = forces the code to recover ema if any errors are encountered.
                                                // 0 = stops on an error
#define     OPT_AUTO_START              0       // 1 = force the code to automatically start the demo without user interaction
                                                // 0 = user must press and hold sw7 for 2 seconds or 's' in the terminal to start the demo
#define     OPT_PERIODIC_STATISTIC      0       // 1 = Periodic Mode => sends the statistic(temp, hum, adc, etc) data to the cloud periodically(~30 seconds).
                                                // WARNING, Periodic Mode consumes a lot more cellular data. 
                                                // 0 = Delta Mode => sends the statistic data when a change of defined deltas(below) occurs
#if OPT_PERIODIC_STATISTIC == 0
    #define TEMP_DELTA                  .5f     // change in deg F
    #define R_HUM_DELTA                 2       // change in rel hum %
    #define EMA_V_DELTA                 .1f     // change in ema voltage
    #define SYS_V_DELTA                 .5F     // change in sys voltage
    #define SIG_Q_DELTA                 1       // change in sig q or "bars"
    #define LIGHT_DELTA                 75      // change in light adc %
    #define USER_ADC_DELTA              75      // change in user adc %
#endif

#endif /* EMAPLAY_CONFIG_H_ */