/*
 * queue.c
 *
 * Created: 7/8/2019 11:59:16 AM
 */

#ifndef __QUEUE_H__
#define __QUEUE_H__

//
// Transmitter and receiver data structures:
//
struct q_struct {
   char *q_in;             // Pointer to next buffer input position.
   char *q_out;            // Pointer to next buffer output position.
   char *q_start;          // Pointer to buffer first location.
   char *q_end;            // Pointer to buffer last location + 1.
   char q_status;          // Status bits for queue and rx/tx errors.
};

typedef struct q_struct Q_STRUCT;

void setup_queue( Q_STRUCT *q, char *buffer, unsigned buffer_size );
int char_into_queue( Q_STRUCT *q, char c );
int char_outof_queue( Q_STRUCT *q );
unsigned short num_chars_queued( Q_STRUCT *q );

// 
// SWORD version
//
struct sword_q_struct {
   signed short *q_in;             // Pointer to next buffer input position.
   signed short *q_out;            // Pointer to next buffer output position.
   signed short *q_start;          // Pointer to buffer first location.
   signed short *q_end;            // Pointer to buffer last location + 1.
   char q_status;          // Status bits for queue and rx/tx errors.
};

typedef struct sword_q_struct SWORD_Q_STRUCT;

void sword_setup_queue( SWORD_Q_STRUCT *q, signed short *buffer, unsigned buffer_size );
int sword_into_queue( SWORD_Q_STRUCT *q, signed short c );
int sword_outof_queue( SWORD_Q_STRUCT *q );


// 
// WORD version
//
struct word_q_struct {
   unsigned short *q_in;             // Pointer to next buffer input position.
   unsigned short *q_out;            // Pointer to next buffer output position.
   unsigned short *q_start;          // Pointer to buffer first location.
   unsigned short *q_end;            // Pointer to buffer last location + 1.
   char q_status;          // Status bits for queue and rx/tx errors.
};

typedef struct word_q_struct WORD_Q_STRUCT;

void word_setup_queue( WORD_Q_STRUCT *q, unsigned short *buffer, unsigned buffer_size );
int word_into_queue( WORD_Q_STRUCT *q, unsigned short c );
int word_outof_queue( WORD_Q_STRUCT *q );


// sword version

#endif // __UART_QUEUE_H__

