/*
 * ema_test.h
 *
 * Created: 7/25/2019 12:38:07 PM
 *  Author: matt.voigt
 */ 

#ifndef EMA_TEST_H_
#define EMA_TEST_H_

#include "oc_ema_mgmt_at.h"
#include "oc_ema_modem_at.h"

#define     EMA_TEST_TASK_INTERVAL                  100
    
#define     EMA_AT_READY_MAX_TIME                   5000
#define     EMA_READY_MAX_TIME                      20000   // ms 
#define     EMA_MODULE_AT_READY_MAX_TIME            60000
#define     EMA_MODULE_READY_FROM_RESET             25000
#define     EMA_POWERING_OFF_MAX_TIME               45000
#define     EMA_RESET_SHORT_MAX_TIME                2000
#define     EMA_RESET_MAX_TIME                      5000
                                                         
#define     EMA_MODULE_AT_READY_POLLING_INTERVAL    1000    //   
#define     EMA_AT_CMDS_INTERVAL                    1000

#define     EMA_MODULE_RESET_TIME_SHORT             50
#define     EMA_MODULE_RESET_TIME_LONG              1000
#define     EMA_MODULE_RESET_INCREMENT              200

//#define     OLD_TEST
enum ema_test_state
{
    EMA_TEST_IDLE = 0,
    EMA_TEST_ST_START,
    EMA_TEST_ST_APPLY_POWER,
        EMA_RESULT_ST_URC_APPLY_POWER,
    EMA_TEST_ST_AT_CMDS,
        EMA_RESULT_ST_AT_CMDS,
            EMA_AT_TEST_ST_LIST_CMDS,
            EMA_AT_TEST_ST_AT,
            EMA_AT_TEST_ST_ECHO,
            EMA_AT_TEST_ST_SN,
            EMA_AT_TEST_ST_BID,
            EMA_AT_TEST_ST_FW_VER,
        EMA_RESULT_APPLY_POWER_CHECK_COMMS,
        EMA_RESULT_CHECK_STS_PIN_LOW,
    EMA_TEST_ST_TURN_ON,
        EMA_RESULT_ST_URC_TURN_ON,
        EMA_RESULT_ST_TURN_ON_CHECK_COMMS,
        EMA_RESULT_ST_CHECK_STS_PIN_HIGH,
    // repeat EMA_TEST_ST_AT_CMDS
    EMA_TEST_ST_NETWORK_STATUS,
        EMA_RESULT_ST_NETWORK_STATUS,
    EMA_TEST_ST_CONNECTION_TEST,
        EMA_RESULT_ST_CONNECTION_TEST,
    EMA_TEST_ST_RESET_MEASURE,
        EMA_RESULT_RESET_MEASURE,
    EMA_TEST_ST_RESET_COMPLETE,
        EMA_RESULT_RESET_COMPLETE,
        EMA_RESULT_RESET_COMPLETE_CHECK_COMMS,
    EMA_TEST_ST_TURN_OFF,
        EMA_RESULT_ST_URC_TURN_OFF,
        EMA_RESULT_ST_TURN_OFF_CHECK_COMMS,
    EMA_TEST_ST_TURN_ON2,
        EMA_RESULT_ST_URCS_TURN_ON2,
        EMA_RESULT_ST_TURN_ON2_CHECK_COMMS,
    EMA_TEST_ST_TURN_OFF2,
        EMA_RESULT_ST_URC_TURN_OFF2,
        EMA_RESULT_ST_TURN_OFF2_CHECK_COMMS,
    EMA_TEST_ST_REMOVE_POWER,
        EMA_RESULT_ST_REMOVE_POWER_CHECK_COMMS,
    EMA_TEST_ST_FAILED,
    EMA_TEST_ST_SUMMARY,
    EMA_TEST_ST_COMPLETE,
    MAX_NUM_TEST_STATES
};

struct test_summary
{
    char            test_step[8];
    unsigned char   test_step_length;
    char            test_name[128];
    unsigned char   test_name_length;
    char            start_time[32];
    unsigned char   start_time_length;
    char            end_time[32];
    unsigned char   end_time_length;
    char            result[16];
    unsigned char   result_length;
    char            str_result[64];
    unsigned char   str_result_length;
    char            verbose_data[128];
    unsigned char   verbose_data_length;
};

void emaTest_task( struct ema_mgmt_context *mgmt_handle, struct modem_at_context *at_handle );
void emaTest_write_test_result( int sum_idx, int timestamp, char *event, int result, char *verbose_data, unsigned short data );
void emaTest_write_test_result_str( int sum_idx, int timestamp, char *event, int result, char *verbose_data, char *result_str );
void emaTest_write_test_msg( int sum_idx, int timestamp, char *msg );
uint8_t emaTest_checkURC( struct ema_mgmt_context *mgmt_handle, unsigned long URCMask );


#endif /* EMA_TEST_H_ */