/*
 * oc_ema_mgmt_at.h
 *
 * Created: 6/24/2019 11:50:06 AM
 *  Author: matt.voigt
 */ 

#ifndef OC_EMA_MGMT_AT_H_
#define OC_EMA_MGMT_AT_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*############ ema AT cmd definitions ###########*/
#define EMA_AT_CMD_MAX_SIZE             128
#define EMA_AT_CMD_RESPONSE_MAX_SIZE    256

struct ema_mgmt_context
{
    char at_cmd[EMA_AT_CMD_MAX_SIZE];
    unsigned char at_cmd_flags;
        #define     MGMT_FL_SYNC_RX     (1<<0)

    char response[EMA_AT_CMD_RESPONSE_MAX_SIZE];
    unsigned short response_length;
    unsigned char response_flags; 

    unsigned long  urc_status;
        #define     MGMT_CNTX_EMA_AT_READY              (1<<0)
        #define     MGMT_CNTX_MODULE_POWERING_ON        (1<<1)
        #define     MGMT_CNTX_MODULE_READY              (1<<2)    
            #define     MGMT_CNTX_MODULE_READY_GROUP           ( MGMT_CNTX_MODULE_POWERING_ON | MGMT_CNTX_MODULE_READY)
        #define     MGMT_CNTX_MODULE_POWERING_OFF       (1<<3)
        #define     MGMT_CNTX_MODULE_POWERED_OFF        (1<<4)    
            #define     MGMT_CNTX_MODULE_OFF_GROUP             (MGMT_CNTX_MODULE_POWERING_OFF | MGMT_CNTX_MODULE_POWERED_OFF)
        #define     MGMT_CNTX_MODULE_UART_READY         (1<<5)
        #define     MGMT_CNTX_MODULE_UART_DOWN          (1<<6)
        #define     MGMT_CNTX_MODULE_RESET_REQ          (1<<10)
        #define     MGMT_CNTX_MODULE_RESETTING          (1<<11)
        #define     MGMT_CNTX_MODULE_RESET              (1<<12)
        #define     MGMT_CNTX_MODULE_RESET_SHORT        (1<<13)
            #define     MGMT_CNTX_EMA_RESET_GROUP           (MGMT_CNTX_MODULE_RESET_REQ | MGMT_CNTX_MODULE_RESETTING | MGMT_CNTX_MODULE_RESET) 
            #define     MGMT_CNTX_EMA_RESET_SHORT_GROUP     (MGMT_CNTX_MODULE_RESET_REQ | MGMT_CNTX_MODULE_RESET_SHORT)
};

// at cmd query function (user provided) via emaModAT_init()
int (*ema_at_comm_handle)(struct ema_mgmt_context *);

void emaMgmtAT_Init( int (*func_ptr)(struct ema_mgmt_context *), struct ema_mgmt_context *handle );
int emaMgmtAT_CheckComm( struct ema_mgmt_context *context );
int emaMgmtAT_DisableEcho( struct ema_mgmt_context *context );
int emaMgmtAT_EnableEcho( struct ema_mgmt_context *context );
int emaMgmtAT_CheckOK( char *buff, unsigned short *len );
int emaMgmtAT_GetFWVersion( struct ema_mgmt_context *context, char *fw_string );
int emaMgmtAT_GetSN( struct ema_mgmt_context *context, char *sn_string );
int emaMgmtAT_SetBID( struct ema_mgmt_context *context, char *bid_string );
int emaMgmtAT_GetBID( struct ema_mgmt_context *context, char *bid_string );
int emaMgmtAT_BIDTestCmd( struct ema_mgmt_context *context, char *formatting );
int emaMgmtAT_ListAvailCMDs( struct ema_mgmt_context *context, char *cmd_list );

// status codes
#define MGMT_AT_ST_NO_OK        -1
#define MGMT_AT_ST_BAD_RESPONSE 0
#define MGMT_AT_ST_SUCCESS      1

/*###########################################*/

/*############ ema URC & cmd definitions ###########*/
#define MGMT_URC_AT_READY                   0//253
#define MGMT_URC_POWERING_ON                1
#define MGMT_URC_READY                      2
#define MGMT_URC_POWERING_OFF               3
#define MGMT_URC_POWERED_OFF                4
#define MGMT_URC_EMA_REBOOTING_NOW          5
#define MGMT_URC_EMA_REBOOTING_60_SECONDS   6
#define MGMT_URC_MODULE_UART_ESTABLISHED    7
#define MGMT_URC_USB_ESTABLISHED            8
#define MGMT_URC_MODULE_UART_REMOVED        9
#define MGMT_URC_USB_REMOVED                10
#define MGMT_URC_MODULE_RESET_REQUESTED     11
#define MGMT_URC_MODULE_RESETTING           12
#define MGMT_URC_MODULE_RESET_SUCCESS       13
#define MGMT_URC_MODULE_RESET_NOT_OBSERVED  14
#define MGMT_URC_INVALID                    255

int emaMgmtURC_GetValues( char *buff, unsigned short len, char* URCs );
int emaMgmtURC_GetValue( char *msg, unsigned short len );

/*###########################################*/

#endif /* OC_EMA_MGMT_AT_H_ */