/*
 * oc_ema_modem_at.h
 *
 * Created: 6/24/2019 11:48:45 AM
 *  Author: matt.voigt
 */ 

#ifndef OC_EMA_MODEM_AT_H_
#define OC_EMA_MODEM_AT_H_

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*############ AT cmd definitions ###########*/
#define AT_CMD_MAX_SIZE             768
#define AT_CMD_RESPONSE_MAX_SIZE    1500
#define ASYNCH_RESPONSE_MAX_SIZE    128

struct modem_at_context
{
    char at_cmd[AT_CMD_MAX_SIZE];
    unsigned char at_cmd_flags;
        #define     MODULE_FL_SYNC_RX           (1<<0)  // tells the tx/rx func know a response is expected
        #define     MODULE_FL_SPECIAL_CMD       (1<<1)  // tells the tx/rx func that 0x1a is the msg terminator
    unsigned short data_length;                         // only used when the end of the data cannot be determined and must used length

    char response[AT_CMD_RESPONSE_MAX_SIZE];
    char async_response[ASYNCH_RESPONSE_MAX_SIZE];
    unsigned short response_length;
    unsigned char response_flags; 
        #define     MODULE_FL_NOT_EXP_OK_ERROR  (1<<0)  // tells the tx/rx to not look for the ok or error strings

    unsigned short  status;
        #define    MODEM_CNTX_AT_READY     (1<<0)
};

// at cmd query function (user provided) via emaModAT_init()
int (*at_comm_handle)(struct modem_at_context *, unsigned short tx_timeout, unsigned short res_timeout, const char *res_pattern);
// at cmd wait and receive function (user provided) via emaModAT_init()
int (*at_asynch_rcv_handle)(struct modem_at_context *, unsigned short wait_time);

void emaModemAT_Init( int (*at_query_ptr)(struct modem_at_context *, unsigned short tx_timeout, unsigned short res_timeout, const char *res_pattern), 
                      int (*at_asynch_rcv_ptr)(struct modem_at_context *, unsigned short wait_time), 
                      struct modem_at_context *at_handle );
    #define MODEM_AT_TX_WAITITME    50
    #define MODEM_AT_RES_WAITTIME   200
int emaModemAT_CheckComm( struct modem_at_context *context );
int emaModemAT_DisableEcho( struct modem_at_context *context );
int emaModemAT_EnableErrorReporting( struct modem_at_context *context, unsigned char level );
int emaModemAT_CheckOK( char *buff, unsigned short *len );
int emaModemAT_CheckError( char *buff );
int emaModemAT_GetSignalQuality( struct modem_at_context *context, 
                                 unsigned char *rxlev, 
                                 unsigned char *ber,
                                 unsigned char *rscp,
                                 unsigned char *ecno,
                                 unsigned char *rsrq,
                                 unsigned char *rsrp );
int emaModemAT_GetNetworkStatus( struct modem_at_context *context, unsigned char *reg, unsigned char *acc_tech, char *op );
int emaModemAT_ConfigSocket( struct modem_at_context *context, unsigned char connID, 
                                                               unsigned char cntxID,
                                                               unsigned short TcpPktSz,
                                                               unsigned short inActTimeout,
                                                               unsigned short connTimeout,
                                                               unsigned short txDataTimeout );
    #define TCP_PCKT_SZ_DEFAULT         300 // bytes
    #define INACT_TIMEOUT_DEFAULT       90  // seconds
    #define CONN_TIMEOUT_DEFAULT        600 // deci-seconds = 600 x .1 = 60 seconds
    #define TX_DATA_TIMEOUT_DEFAULT     50  // deci-seconds = 50 x .1 = 5 seconds
int emaModemAT_OpenSocket( struct modem_at_context *context, unsigned char connID, 
                                                             unsigned char txProt,
                                                             unsigned short remotePort,
                                                             char *IPorHostname,
                                                             unsigned char closeType,
                                                             unsigned short localPort,
                                                             unsigned char connMode );
    #define TX_PROTOCOL_TCP             0
    #define TX_PROTOCOL_UDP             1
    #define CLOSE_TYPE_IMMEDIATELY      0   // socket will close when host closed socket
    #define CLOSE_TYPE_CLOSE_SOCKET     255 // socket will close when clost close socket cmd sent
    #define CONN_MODE_ONLINE            0
    #define CONN_MODE_COMMAND           1
int emaModemAT_SocketStatus( struct modem_at_context *context );
int emaModemAT_CloseSocket( struct modem_at_context *context, unsigned char connID );
int emaModemAT_SocketSend( struct modem_at_context *context, unsigned char connID, char *data );
    #define SEND_DATA_CONFIRM           0x1a
    #define SEND_DATA_ESCAPE            0x1b
int emaModemAT_SocketRecv( struct modem_at_context *context, unsigned char connID, char *recv_data, unsigned short *recv_len );


int emaModemAT_ActivatePDPCntx( struct modem_at_context *context, unsigned char cntxID );
int emaModemAT_DeactivatePDPCntx( struct modem_at_context *context, unsigned char cntxID );
    #define ATT_CONTEXT_ID              1
    #define VZW_CONTEXT_ID              6
int emaModemAT_HTTPQueryRaw( struct modem_at_context *context, unsigned char connID, 
                                                               unsigned char cntxID, 
                                                               char *IPorHostname, 
                                                               char *http_data, 
                                                               char *http_repsonse,
                                                               unsigned short *resp_len );
    #define HTTP_REQUEST_ERROR          0
int emaModemAT_HTTPPost( struct modem_at_context *context, unsigned char profID, 
                                                           unsigned char cntxID, 
                                                           char *IPorHostname, 
                                                           unsigned char ssl,
                                                           char *http_resource_uri,
                                                           char *content_type_id,
                                                           char *extra_header, 
                                                           char *data,
                                                           unsigned short data_len,
                                                           char *http_resp_content_type,
                                                           char *http_reps,
                                                           unsigned short *http_resp_len );
int emaModemAT_ConfigHTTP( struct modem_at_context *context, unsigned char profID,  
                                                             char *IPorHostname,  
                                                             unsigned short server_port,
                                                             unsigned char ssl, 
                                                             unsigned short recv_timeout,
                                                             unsigned char cntxID,   
                                                             unsigned short pckt_size );
    #define HTTP_RCV_TIMEOUT_DEFAULT        120 // seconds. time to wait for received date from http server
    #define HTTP_PCKT_SIZE_DEFAULT          0   // auto select default 300 bytes
int emaModemAT_HTTPSend( struct modem_at_context *context, unsigned char profID,
                                                           unsigned char cmd,
                                                           char *http_resource_uri,
                                                           char *content_type_id,
                                                           char *extra_header,
                                                           char * data,
                                                           unsigned short data_len );
    #define HTTP_POST                       0
    #define HTTP_PUT                        1
int emaModemAT_HTTPRecv( struct modem_at_context *context, unsigned char profID, unsigned short *http_resp_len, char *http_resp_data );
    #define HTTP_MAX_RECV_SIZE                   1500


// status codes
#define MOD_AT_ST_NO_OK     -1
#define MOD_AT_ST_SUCCESS   1
#define MOD_AT_ST_ERROR     2
#define MOD_AT_ST_UNKNOWN   3

/*###########################################*/

#endif /* OC_EMA_MODEM_AT_H_ */