#include <atmel_start.h>
#include "emaPlay.h"
#include "ema_test.h"
#include <stdio.h>

int main(void)
{
    struct modem_at_context ema_at_handle;
    struct ema_mgmt_context ema_mgmt_handle;

    /* Initializes MCU, drivers and middleware */
    atmel_start_init();
    // init the system 1ms tick time base
    emaPlay_init_sys1ms_tick( );

    // init q's for modem uart rx data
    emaPlay_q_init( &modem_uart_sync_rx_q, modem_uart_sync_rx_q_buff, sizeof(modem_uart_sync_rx_q_buff) );
    emaPlay_q_init( &modem_uart_async_rx_q, modem_uart_async_rx_q_buff, sizeof(modem_uart_async_rx_q_buff) );
    // init q's for mgmt uart rx data
    emaPlay_q_init( &mgmt_uart_sync_rx_q, mgmt_uart_sync_rx_q_buff, sizeof(mgmt_uart_sync_rx_q_buff) );
    emaPlay_q_init( &mgmt_uart_async_rx_q, mgmt_uart_async_rx_q_buff, sizeof(mgmt_uart_async_rx_q_buff) );

    // complete setup of the modem uart 
    emaPlay_uart_setup( &ema_modem_uart, &ema_modem_uart_io, (usart_cb_t)emaPlay_modem_tx_cb, (usart_cb_t)emaPlay_modem_rx_cb );
    // complete setup of the mgmt uart 
    emaPlay_uart_setup( &ema_mgmt_uart, &ema_mgmt_uart_io, (usart_cb_t)emaPlay_mgmt_tx_cb, (usart_cb_t)emaPlay_mgmt_rx_cb );

    // set the at send/receive handler for the modem uart
    emaModemAT_Init( emaPlay_modem_at_query, emaPlay_modem_async_recv, &ema_at_handle );
    // set the at send/receive handler for the mgmt uart
    emaMgmtAT_Init( emaPlay_mgmt_at_query, &ema_mgmt_handle );

    //emaMgmtAT_check_comm( &mgmt_query );
    //emaModemAT_get_signal_quality( &modem_query, &rssi, &ber );

    // init the debug input/output 
    #ifdef DEBUG
    int at_st;
    uint32_t dbg_timer, status_timer;
    uint8_t rxlev, ber, rscp, ecno, rsrq, rsrp, sig_q, reg, acc_tech;
    char op[32];
    dbg_timer = TIME_ELAPSED_ms(0);
    status_timer = TIME_ELAPSED_ms(0);
    emaPlay_q_init( &dbg_rx_q, dbg_q_rx_buff, sizeof(dbg_q_rx_buff) );
    emaPlay_q_init( &dbg_tx_q, dbg_q_tx_buff, sizeof(dbg_q_tx_buff) );
    emaPlay_uart_setup( &emaPlay_debug_uart, &emaPlay_dbg_uart_io, (usart_cb_t)emaPlay_dbg_tx_cb, (usart_cb_t)emaPlay_dbg_rx_cb );
    usart_async_enable( &emaPlay_debug_uart );
    emaPlay_dbg_uart_send( "\r\nema:Play FW Version: ", sizeof("\r\nema:Play FW Version: "), 20, 0 );
    emaPlay_dbg_uart_send( __DATE__, sizeof(__DATE__), 20, 0 );
    emaPlay_dbg_uart_send( "\r\n'?' for menu\r\n", sizeof("\r\n'?' for menu\r\n"), 20, 0 );
    #endif

    #if 0
    // turn ema on
    emaPLay_ema_on_off_control( EMA_O?N_OFF_ST_ON ); 
    TIME_DELAY_ms(500);
    emaPLay_ema_power_control( EMA_POWER_ST_ON );

    // enable the uart(s), after turning ema on to prevent junk recieved data
    usart_async_enable( &ema_modem_uart );
    usart_async_enable( &ema_mgmt_uart );
    #endif

    TIME_DELAY_ms(1000);

    // main application loop
    while (1) {


        // handle any asynch URCs, this must be called frequently and periodically
        emaPlay_mgmt_URC_handler( &ema_mgmt_handle );

        if ( halt_test == 0 ) {
            emaTest_task(&ema_mgmt_handle, &ema_at_handle );
        }else{
            // update emaPlay hardware
            if ( TIME_ELAPSED_ms(status_timer) >= EMA_STATUS_INTERVAL ) {
                status_timer = TIME_ELAPSED_ms(0);
                if ( (ema_mgmt_handle.urc_status & (MGMT_CNTX_MODULE_READY | MGMT_CNTX_MODULE_UART_READY)) == (MGMT_CNTX_MODULE_READY | MGMT_CNTX_MODULE_UART_READY)) {
                    // sig q
                    at_st = emaModemAT_GetSignalQuality( &ema_at_handle, &rxlev, &ber, &rscp, &ecno, &rsrq, &rsrp );
                    if ( at_st == MOD_AT_ST_SUCCESS ) {
                        sig_q = emaPlay_ema_qualify_signal(rsrq, rsrp);
                        emaPlay_update_led_graph( &sig_q );
                    }
                    // network status
                    at_st = emaModemAT_GetNetworkStatus( &ema_at_handle, &reg, &acc_tech, op );
                    if ( at_st == MOD_AT_ST_SUCCESS ) {
                        // reg
                        if ( reg == 1 ) {
                            gpio_set_pin_level(red_led0, false);
                            // op
                            if ( strstr( op, "AT&T" ) ) {
                                gpio_set_pin_level(red_led1, true );
                            } else if ( strstr( op, "Verizon" ) ) {
                                gpio_set_pin_level(red_led1, false);
                            }else{
                                gpio_set_pin_level(red_led1, true );
                            }
                        }else{
                            gpio_set_pin_level(red_led0, true);
                            gpio_set_pin_level(red_led1, true );
                        }
                    }
                }
            }
            // process sw pressed
            if ( sw0_pending ) {
                // stuff into the dbg q to simulate a key press
                emaPlay_q_put( &dbg_rx_q, 'p' );
                sw0_pending = 0;
            }
            // process sw pressed
            if ( sw1_pending ) {
                // stuff into the dbg q to simulate a key press
                emaPlay_q_put( &dbg_rx_q, 'o' );
                sw1_pending = 0;
            }

        }

        #ifdef DEBUG
        if ( TIME_ELAPSED_ms(dbg_timer) >= DBG_TASK_INTERVAL ){
            dbg_timer = TIME_ELAPSED_ms(0);
            dbg_task( &ema_mgmt_handle, &ema_at_handle );
        }
        #endif
    }
}
