/*
 * emaPlay.h
 *
 * Created: 6/24/2019 11:59:32 AM
 *  Author: matt.voigt
 */ 


#ifndef EMAPLAY_H_
#define EMAPLAY_H_

#include <atmel_start.h>
#include <queue.h>
#include "oc_ema_modem_at.h"
#include "oc_ema_mgmt_at.h"

#define BIT0    1<<0
#define BIT1    1<<1
#define BIT2    1<<2
#define BIT3    1<<3
#define BIT4    1<<4
#define BIT5    1<<5
#define BIT6    1<<6
#define BIT7    1<<7

/*####### Timer Related Functionlaity #######*/
// theser variables should NEVER be written to
extern uint32_t u32Sys1msTic;
extern uint32_t u32Sys1secTic;
extern uint32_t inlineTimer;  

// polled timer macro
// usage:   1. Snapshot current time ->         var = TIME_ELAPSED_ms(0);
//          2. Compare against desired delay -> if (TIME_ELAPSED_ms(var) > 500) 
//                                              { 
//                                                  do something(at 500 ms interval)
//                                                  // reset timer
//                                                  var = TIME_ELAPSED_ms(0);    
//                                              } 
#define TIME_ELAPSED_ms(x)          u32Sys1msTic - x

// inline/serial delay timer macro
// usage:   1. do something
//          2. TIME_DELAY_ms(250) // delats for 250 ms
//          3. continue to do something
#define TIME_DELAY_ms(x)            inlineTimer = TIME_ELAPSED_ms(0); while ( TIME_ELAPSED_ms(inlineTimer) < x ){asm("NOP");};   

void emaPlay_system_1ms_tick_cb( void );
void emaPlay_init_sys1ms_tick( void );
/*###########################################*/

/*####### Queue Related Functionlaity  ######*/
extern Q_STRUCT modem_uart_sync_rx_q, modem_uart_async_rx_q;
extern Q_STRUCT mgmt_uart_sync_rx_q, mgmt_uart_async_rx_q;
#define AT_RX_Q_BUFF_SIZE       1024
#define EMA_AT_RX_Q_BUFF_SIZE   256
extern char modem_uart_sync_rx_q_buff[AT_RX_Q_BUFF_SIZE];
extern char modem_uart_async_rx_q_buff[AT_RX_Q_BUFF_SIZE];
extern char mgmt_uart_sync_rx_q_buff[EMA_AT_RX_Q_BUFF_SIZE];
extern char mgmt_uart_async_rx_q_buff[EMA_AT_RX_Q_BUFF_SIZE];

void emaPlay_q_init( struct q_struct *q, char *buffer, unsigned buffer_size );
int emaPlay_q_put( Q_STRUCT *q, char data );
int emaPlay_q_get( Q_STRUCT *q,unsigned short timeout );

// q status codes
#define Q_ST_TIMEOUT                -2 
#define Q_ST_EMPTY                  -1
#define Q_ST_NOT_VALID              -1
#define Q_ST_FULL                   0
#define Q_ST_SUCCESS                1
// q flags
#define Q_FL_RETRY_TO_TIMEOUT       BIT0            // retries the q operation until timeout(ms) reached

/*###########################################*/

/*####### modem/ema UART Functionality ######*/
extern struct io_descriptor *ema_modem_uart_io;
extern struct io_descriptor *ema_mgmt_uart_io;

void emaPlay_uart_setup( struct usart_async_descriptor *const uart, struct io_descriptor **io_rw, usart_cb_t tx_callback, usart_cb_t rx_callback );
int emaPlay_modem_uart_send( uint8_t *buffer, uint16_t len, uint16_t timeout, uint8_t flags );
int emaPlay_modem_uart_receive( uint8_t *buffer, uint16_t *len, uint16_t timeout, uint8_t flags, const char* pattern );
void emaPlay_modem_tx_cb ( void );
void emaPlay_modem_rx_cb ( void );
int emaPlay_mgmt_uart_send( uint8_t *buffer, uint16_t len, uint16_t timeout, uint8_t flags );
int emaPlay_mgmt_uart_receive( uint8_t *buffer, uint16_t *len, uint16_t timeout );
void emaPlay_mgmt_tx_cb ( void );
void emaPlay_mgmt_rx_cb ( void );

// uart status codes
#define UART_ST_TIMEOUT             Q_ST_TIMEOUT
#define UART_ST_TX_SUCCESS          Q_ST_SUCCESS

/*###########################################*/

#ifdef DEBUG
/*####### Debug Functionality ######*/
#define     EMA_STATUS_INTERVAL   30000
#define     DBG_TASK_INTERVAL     20  // ms 
#define     DBG_Q_BUFF_SIZE       4096
  
extern char http_msg[];  
extern char http_rcv_buf[];

extern uint8_t halt_test;
extern uint8_t exp_carrier;

extern struct io_descriptor *emaPlay_dbg_uart_io;
extern Q_STRUCT dbg_rx_q, dbg_tx_q;
extern char dbg_q_rx_buff[DBG_Q_BUFF_SIZE];
extern char dbg_q_tx_buff[DBG_Q_BUFF_SIZE];

void emaPlay_dbg_out( char *dbg_data, uint16_t len );
void emaPlay_dbg_tx_cb ( void );
void emaPlay_dbg_rx_cb ( void );
int emaPlay_dbg_uart_send( char *buffer, uint16_t len, uint16_t timeout, uint8_t flags );
int emaPlay_dbg_uart_receive( uint8_t *buffer, uint16_t *len, uint16_t timeout );
void dbg_task(struct ema_mgmt_context *mgmt_handle, struct modem_at_context *at_handle);
/*###########################################*/
#endif

/*##########  AT cmd Functionality ##########*/
int emaPlay_modem_at_query( struct modem_at_context *at_query, unsigned short tx_timeout, unsigned short res_timeout, const char *res_pattern );
int emaPlay_mgmt_at_query( struct ema_mgmt_context *at_query );
int emaPlay_modem_async_recv( struct modem_at_context *at_query, unsigned short wait_time );
/*###########################################*/

/*##########  ema URC & cmd Functionality ##########*/
void emaPlay_mgmt_URC_handler( struct ema_mgmt_context *at_query );
void emaPlay_mgmt_process_URC( struct ema_mgmt_context *at_query, int urc );
/*###########################################*/

/*###### ema:Play GPIO Functionality  #######*/
enum ema_on_off_state
{
    EMA_ON_OFF_ST_ON = 0,
    EMA_ON_OFF_ST_OFF,
    EMA_ON_OFF_ST_TOGGLE
};

enum ema_power_state
{
    EMA_POWER_ST_ON = 0,
    EMA_POWER_ST_OFF,
    EMA_POWER_ST_TOGGLE
};

void emaPlay_ema_on_off_control( enum ema_on_off_state state );
void emaPlay_ema_power_control( enum ema_power_state state );

void emaPlay_ema_reset( uint16_t reset_time );

/*###########################################*/

/*###### ema:Play App level functions  #######*/
extern uint8_t sw0_pending, sw1_pending;
extern uint8_t sts_state;

void emaPlay_ema_mgmt_task( struct ema_mgmt_context *handle );
void emaPlay_ema_apply_power( void );
void emaPlay_ema_remove_power( void );
void emaPlay_ema_turn_on( void );
void emaPlay_ema_turn_off( void );
unsigned char emaPlay_ema_qualify_signal( unsigned char rsrq, unsigned char rsrp );
    #define     SIGNAL_UNKNOWN      0
    #define     SIGNAL_POOR         1
    #define     SIGNAL_FAIR         2
    #define     SIGNAL_GOOD         3
    #define     SIGNAL_EXCELLENT    4 
void emaPlay_update_led_graph( uint8_t *sig );
/*###########################################*/

#endif /* EMAPLAY_H_ */