/*
 * Code generated from Atmel Start.
 *
 * This file will be overwritten when reconfiguring your Atmel Start project.
 * Please copy examples or other code you want to keep to a separate file
 * to avoid losing it when reconfiguring.
 */

#include "driver_examples.h"
#include "driver_init.h"
#include "utils.h"

/**
 * Example of using emaPlay_debug_uart to write "Hello World" using the IO abstraction.
 *
 * Since the driver is asynchronous we need to use statically allocated memory for string
 * because driver initiates transfer and then returns before the transmission is completed.
 *
 * Once transfer has been completed the tx_cb function will be called.
 */

static uint8_t example_emaPlay_debug_uart[12] = "Hello World!";

static void tx_cb_emaPlay_debug_uart(const struct usart_async_descriptor *const io_descr)
{
	/* Transfer completed */
}

void emaPlay_debug_uart_example(void)
{
	struct io_descriptor *io;

	usart_async_register_callback(&emaPlay_debug_uart, USART_ASYNC_TXC_CB, tx_cb_emaPlay_debug_uart);
	/*usart_async_register_callback(&emaPlay_debug_uart, USART_ASYNC_RXC_CB, rx_cb);
	usart_async_register_callback(&emaPlay_debug_uart, USART_ASYNC_ERROR_CB, err_cb);*/
	usart_async_get_io_descriptor(&emaPlay_debug_uart, &io);
	usart_async_enable(&emaPlay_debug_uart);

	io_write(io, example_emaPlay_debug_uart, 12);
}

void I2C_example(void)
{
	struct io_descriptor *I2C_io;

	i2c_m_sync_get_io_descriptor(&I2C, &I2C_io);
	i2c_m_sync_enable(&I2C);
	i2c_m_sync_set_slaveaddr(&I2C, 0x12, I2C_M_SEVEN);
	io_write(I2C_io, (uint8_t *)"Hello World!", 12);
}

/**
 * Example of using ema_mgmt_uart to write "Hello World" using the IO abstraction.
 *
 * Since the driver is asynchronous we need to use statically allocated memory for string
 * because driver initiates transfer and then returns before the transmission is completed.
 *
 * Once transfer has been completed the tx_cb function will be called.
 */

static uint8_t example_ema_mgmt_uart[12] = "Hello World!";

static void tx_cb_ema_mgmt_uart(const struct usart_async_descriptor *const io_descr)
{
	/* Transfer completed */
}

void ema_mgmt_uart_example(void)
{
	struct io_descriptor *io;

	usart_async_register_callback(&ema_mgmt_uart, USART_ASYNC_TXC_CB, tx_cb_ema_mgmt_uart);
	/*usart_async_register_callback(&ema_mgmt_uart, USART_ASYNC_RXC_CB, rx_cb);
	usart_async_register_callback(&ema_mgmt_uart, USART_ASYNC_ERROR_CB, err_cb);*/
	usart_async_get_io_descriptor(&ema_mgmt_uart, &io);
	usart_async_enable(&ema_mgmt_uart);

	io_write(io, example_ema_mgmt_uart, 12);
}

/**
 * Example of using ema_modem_uart to write "Hello World" using the IO abstraction.
 *
 * Since the driver is asynchronous we need to use statically allocated memory for string
 * because driver initiates transfer and then returns before the transmission is completed.
 *
 * Once transfer has been completed the tx_cb function will be called.
 */

static uint8_t example_ema_modem_uart[12] = "Hello World!";

static void tx_cb_ema_modem_uart(const struct usart_async_descriptor *const io_descr)
{
	/* Transfer completed */
}

void ema_modem_uart_example(void)
{
	struct io_descriptor *io;

	usart_async_register_callback(&ema_modem_uart, USART_ASYNC_TXC_CB, tx_cb_ema_modem_uart);
	/*usart_async_register_callback(&ema_modem_uart, USART_ASYNC_RXC_CB, rx_cb);
	usart_async_register_callback(&ema_modem_uart, USART_ASYNC_ERROR_CB, err_cb);*/
	usart_async_get_io_descriptor(&ema_modem_uart, &io);
	usart_async_enable(&ema_modem_uart);

	io_write(io, example_ema_modem_uart, 12);
}
