/*
 * oc_leaf.h
 *
 * Created: 9/24/2019 3:28:46 PM
 *  Author: matt.voigt
 */ 


#ifndef OC_LEAF_H_
#define OC_LEAF_H_

#include "oc_ema_modem_at.h"

//#define TASK_LEAF_STACK_SIZE (768 / sizeof(portSTACK_TYPE))
//#define TASK_LEAF_PRIORITY (tskIDLE_PRIORITY + 3)

#define LEAF_MAX_MESSAGE_SIZE 3000
#define LEAF_MESSAGE_QUEUE_SIZE 10000

#define LEAF_MODEM_COMMAND_TIMEOUT 2000
#define LEAF_MODEM_QUERY_TIMEOUT 2000
#define LEAF_MODEM_HTTP_POST_TIMEOUT 32000
#define LEAF_MODEM_HTTPRECV_TIMEOUT 2000
#define LEAF_MODEM_HTTPRING_TIMEOUT 5000

#define LEAF_MAX_COMMAND_PARAMS 10

enum LeafMessageTypes {
    LEAF_STATISTIC = 0,
    LEAF_EVENT = 1,
    LEAF_NOOP = 2
};

int start_leaf( struct modem_at_context *context, unsigned char cntx_id,
                                                  char *leaf_device_id, 
                                                  char *leaf_host, 
                                                  char *realm, 
                                                  char *user, 
                                                  char *password,
                                                  void (*callback)(char *, char**, int));

int build_leaf_noop( void );
int build_leaf_message(int message_type, char *message_sub_type, char *data);
int send_leaf_query( struct modem_at_context *context, unsigned char cntx_id, int data_len );

#endif /* OC_LEAF_H_ */