/*
 * ema_test.c
 *
 * Created: 7/25/2019 12:37:54 PM
 *  Author: matt.voigt
 */ 

#include "ema_test.h"
#include "emaPlay.h"

// test summary container
static struct test_summary summary[MAX_NUM_TEST_STATES];

void emaTest_task( struct ema_mgmt_context *mgmt_handle, struct modem_at_context *at_handle )
{
    static uint8_t test_st = EMA_TEST_ST_START;
    static uint8_t ema_at_test_st = EMA_AT_TEST_ST_LIST_CMDS;
    static uint32_t time_start, time_end, cmd_interval;
    static uint8_t test_st_loop = 0;
    int at_st, l;
    unsigned char data[64];
    static char sn[64];
    static char fw[64];
    char str[64];
    char data2[] = "OCemaTest";
    static char test_step = 0;  // must be incrmented at start of each test
    char col, i;
    static uint16_t reset_time = 200;
    unsigned char q, exp_carrier_test, cntx;
    unsigned short len;

    switch ( test_st ) {
    case EMA_TEST_IDLE:
        // waiting for input from user

        break;
    case EMA_TEST_ST_START:

        emaPlay_dbg_out( "\r\n------ ema embedded side Validation Test ------\r\n", 51 );
        //emaPlay_dbg_out( "\r\n\r\nLog Format: Timestamp, Event, Result, Verbose Data(string), Data(hex)\r\n\r\n", 77 );

        test_st = EMA_TEST_ST_APPLY_POWER;

        break;
    case EMA_TEST_ST_APPLY_POWER:

        test_step++;
        emaTest_write_test_msg( test_step, u32Sys1msTic, "Apply Power Test");
        time_start = TIME_ELAPSED_ms( 0 );
        emaPlay_ema_apply_power( );
        // enable the uart(s), after turning ema on to prevent junk recieved data
        usart_async_enable( &ema_modem_uart );
        usart_async_enable( &ema_mgmt_uart );

        test_st = EMA_RESULT_ST_URC_APPLY_POWER;

        break;
    case EMA_RESULT_ST_URC_APPLY_POWER:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_EMA_AT_READY ) ) {
            // grab the the end time, and log it
            time_end = TIME_ELAPSED_ms( 0 );
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(time_end - time_start), "Apply Power, URC detected in time(mS)", mgmt_handle->urc_status );
            test_st = EMA_TEST_ST_AT_CMDS;
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_AT_READY_MAX_TIME ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_AT_READY_MAX_TIME, "Apply Power, URC Not detected in time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_TEST_ST_AT_CMDS:

        cmd_interval = TIME_ELAPSED_ms(0);
        test_st = EMA_RESULT_ST_AT_CMDS;

        break;
    case EMA_RESULT_ST_AT_CMDS:

        if ( TIME_ELAPSED_ms(cmd_interval) < EMA_AT_CMDS_INTERVAL ) {
            // delaying..
            break;
        }

        switch (ema_at_test_st) {
        case EMA_AT_TEST_ST_LIST_CMDS:

            test_step++;
            // list the at cmds supported by ema
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+CLAC)");
            at_st = emaMgmtAT_ListAvailCMDs(mgmt_handle, (char*)data);
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+CLAC)", (char*)data );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+CLAC)", 0 );
            }

            ema_at_test_st = EMA_AT_TEST_ST_AT;
                                
            break;
        case EMA_AT_TEST_ST_AT:

            test_step++;
            // send the basic at cmd
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT)");
            at_st = emaMgmtAT_CheckComm( mgmt_handle );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT)", 0 );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT)", 0 );
            }

            ema_at_test_st = EMA_AT_TEST_ST_ECHO;

            break;  
        case EMA_AT_TEST_ST_ECHO:

            test_step++;
             // enable echo then disable echo
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(ATE1)");
            at_st = emaMgmtAT_EnableEcho( mgmt_handle );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(ATE1)", 0 );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(ATE1)", 0 );
            }

            test_step++;
            TIME_DELAY_ms(100);
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(ATE0)");
            at_st = emaMgmtAT_DisableEcho( mgmt_handle );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(ATE0)", 0 );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(ATE0)", 0 );
            }

            ema_at_test_st = EMA_AT_TEST_ST_SN;
                                
            break;                              
        case EMA_AT_TEST_ST_SN:

            test_step++;
            // get the ema sn
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+GSN)");
            at_st = emaMgmtAT_GetSN( mgmt_handle, (char*)data );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+GSN)", (char*)data );
                strcpy( sn, (char*)data );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+GSN)", 0 );
            }

            ema_at_test_st = EMA_AT_TEST_ST_BID;
                                
            break;
        case EMA_AT_TEST_ST_BID:

            test_step++;
            // set, then get the board ID, test cmd last
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+OCBID=)");
            at_st = emaMgmtAT_SetBID( mgmt_handle, data2 );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+OCBID=)", data2 );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+OCBID=)", 0 );
            }

            test_step++;
            TIME_DELAY_ms(500);
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+OCBID?)");
            at_st = emaMgmtAT_GetBID( mgmt_handle, (char*)data );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+OCBID?)", (char*)data );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+OCBID?)", 0 );
            }

            test_step++;
            // compare set and get
            emaTest_write_test_msg( test_step, u32Sys1msTic, "ema Board ID Set/Get Compare");
            at_st = strcmp( data2, (char*)data );
            if ( at_st == 0 ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "Board ID Set/Get Compare", (char*)data );
            }else{
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "Board ID Set/Get Compare", (char*)data );
            }

            test_step++;
            TIME_DELAY_ms(500);
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+OCBID=?)");
            at_st = emaMgmtAT_BIDTestCmd( mgmt_handle, (char*)data );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+OCBID=?)", (char*)data );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+OCBID=?)", 0 );
            }

            ema_at_test_st = EMA_AT_TEST_ST_FW_VER;
                  
            break;                              
        case EMA_AT_TEST_ST_FW_VER:

            test_step++; 
            // get the ema FW version
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema AT Cmd Test(AT+GMR)");
            at_st = emaMgmtAT_GetFWVersion( mgmt_handle, (char*)data );
            if ( at_st == MGMT_AT_ST_SUCCESS ) {
                emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", at_st, "AT cmd(AT+GMR)", (char*)data );
                strcpy( fw, (char*)data );
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", at_st, "AT cmd(AT+GMR)", 0 );
            }

            // reset this state machines state
            ema_at_test_st = EMA_AT_TEST_ST_LIST_CMDS;
            if ( test_st_loop == 0 ) {
                test_st = EMA_RESULT_APPLY_POWER_CHECK_COMMS;
                // setup for next test here
                test_step++; 
                // there should be NO module at comms yet, and we already check ema comms in last state
                emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Module AT Fail Cmd Test(AT)");
                time_start = TIME_ELAPSED_ms( 0 );
            }else{
                test_st = EMA_TEST_ST_NETWORK_STATUS;
            }

            break;                              

        default:
            break;
        }

        break;
    case EMA_RESULT_APPLY_POWER_CHECK_COMMS:

        if ( (emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_READY )) == 0 ) {
            at_st = emaModemAT_CheckComm(at_handle);
            if ( at_st == MOD_AT_ST_SUCCESS) {
                at_handle->status |= MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Module responded(AT), module not ON", at_handle->status );
                test_st = EMA_TEST_ST_FAILED;
            }else{
                at_handle->status &= ~MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Module AT Fail AT cmd(AT), module not ON", at_handle->status );
                //test_st = EMA_TEST_ST_TURN_ON;
                test_st = EMA_RESULT_CHECK_STS_PIN_LOW;
            }
        }

        break;
    case EMA_RESULT_CHECK_STS_PIN_LOW:

        test_step++; 
        time_start = TIME_ELAPSED_ms( 0 );
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "STATUS Pin low Test");
        // read the status pin state
        if (sts_state == 0) {
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "STATUS Pin low", sts_state );
            test_st = EMA_TEST_ST_TURN_ON;
        }else{
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "STATUS Pin NOT low", sts_state );
            test_st = EMA_TEST_ST_FAILED;
        }

        break;
    case EMA_TEST_ST_TURN_ON:

        test_step++;
        time_start = TIME_ELAPSED_ms( 0 );
        emaTest_write_test_msg( test_step, time_start, "Turn ON(pin) Test");
        emaPlay_ema_turn_on();

        test_st = EMA_RESULT_ST_URC_TURN_ON;

        break;
    case EMA_RESULT_ST_URC_TURN_ON:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_READY_GROUP ) ) {
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn ON, URCs detected in time(mS)", mgmt_handle->urc_status );

            // prep here for next test
            cmd_interval = TIME_ELAPSED_ms( 0 );
            test_step++; 
            emaTest_write_test_msg( test_step, time_start, "Turn ON(pin), Module Ready Test(AT)");
            test_st = EMA_RESULT_ST_TURN_ON_CHECK_COMMS;
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_READY_MAX_TIME ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_READY_MAX_TIME, "Turn ON, URCs NOT detected in time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_RESULT_ST_TURN_ON_CHECK_COMMS:

        // confirm the module is ready by checking comm
        // send an at cmd to the cell module periodically until we get the ok response
        if ( TIME_ELAPSED_ms(time_start) >= EMA_MODULE_AT_READY_MAX_TIME ) {
            // log failure
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_MODULE_AT_READY_MAX_TIME, "Turn ON(pin), Max time reached(mS)", at_handle->status );
            test_st = EMA_TEST_ST_FAILED;
        }else{
            if ( TIME_ELAPSED_ms( cmd_interval >= EMA_MODULE_AT_READY_POLLING_INTERVAL ) ) {
                cmd_interval = TIME_ELAPSED_ms( 0 );
                if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_READY ) ) {
                    at_st = emaModemAT_CheckComm(at_handle);
                    if ( at_st == MOD_AT_ST_SUCCESS ) {
                        // log the result
                        at_handle->status |= MODEM_CNTX_AT_READY;
                        emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn ON(pin), Module Ready Time(mS)", at_handle->status );
                        //test_st = EMA_TEST_ST_AT_CMDS;
                        test_st = EMA_RESULT_ST_CHECK_STS_PIN_HIGH;
                        test_st_loop = 1;
                    }
                }
            }
        }

       break;
    case EMA_RESULT_ST_CHECK_STS_PIN_HIGH:

        test_step++; 
        time_start = TIME_ELAPSED_ms( 0 );
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "STATUS Pin high Test");
        // read the status pin state
        if (sts_state == 1) {
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "STATUS Pin high", sts_state );
            test_st = EMA_TEST_ST_AT_CMDS;
        }else{
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "STATUS Pin NOT high", sts_state );
            test_st = EMA_TEST_ST_FAILED;
        }

        break;
    case EMA_TEST_ST_NETWORK_STATUS:

        test_step++;
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Network Status Test(wait 20 seconds..)");
        test_st = EMA_RESULT_ST_NETWORK_STATUS;

        // purge any debug data in the q from the last test
        dbg_task( mgmt_handle, at_handle );

        break;

    case EMA_RESULT_ST_NETWORK_STATUS:

        // delay a bit to allow the module to reg and get signal
        TIME_DELAY_ms( 20000 );

        time_start = TIME_ELAPSED_ms( 0 );
        // get the network status from the module
        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_READY ) && ( sts_state == 1 ) ) {
            at_st = emaModemAT_GetNetworkStatus(at_handle, &data[32], &data[33], (char*)&data[34]);
            if ( at_st == MOD_AT_ST_SUCCESS) {
                // check the returned values for registration, acc tech and operator
                if ( data[32] == 1 ) {
                    gpio_set_pin_level(red_led0, false);
                    if ( exp_carrier == 0/*att*/ ) {
                        if ( strstr( (char*)&data[34], "AT&T" ) ){
                            gpio_set_pin_level(red_led1, true );
                            exp_carrier_test = 1;
                        }else{
                            exp_carrier_test = 0;
                        }
                    }else{
                        if ( strstr( (char*)&data[34], "Verizon" ) ){
                            gpio_set_pin_level(red_led1, false);
                            exp_carrier_test = 1;
                        }else{
                            exp_carrier_test = 0;
                        }
                    }

                    if ( exp_carrier_test ) {
                        // get sig qual
                        at_st = emaModemAT_GetSignalQuality( at_handle, &data[0], &data[1], &data[2], &data[3], &data[4], &data[5] );
                        q = emaPlay_ema_qualify_signal( data[4], data[5] );
                        emaPlay_update_led_graph( &q );
                        sprintf( str, "SigQual(0-4): %d, Reg: %d, AccTech: %d, Operator: %s", q, data[32], data[33], &data[34] );
                        emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Module Registered Home", str );
                        test_st = EMA_TEST_ST_CONNECTION_TEST;
                    }else{
                        emaTest_write_test_result_str( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Wrong Carrier", (char*)&data[34] );
                        test_st = EMA_TEST_ST_FAILED;
                    }
                }else{
                    gpio_set_pin_level(red_led0, true);
                    emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Module not Registered Home", data[32] );
                    test_st = EMA_TEST_ST_FAILED;
                }
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Module AT cmd Failed", at_st );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;

    case EMA_TEST_ST_CONNECTION_TEST:

        test_step++;
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Connection test using HTTP");
        // dump debug data
        dbg_task( mgmt_handle, at_handle );
        test_st = EMA_RESULT_ST_CONNECTION_TEST;

        break;
    case EMA_RESULT_ST_CONNECTION_TEST:

        if ( exp_carrier == 0 ) {
            cntx = ATT_CONTEXT_ID;
        }else{
            cntx = VZW_CONTEXT_ID;
        }

        time_start = TIME_ELAPSED_ms( 0 );
        at_st = emaModemAT_HTTPQueryRaw(at_handle, 1, cntx, "httpbin.org", http_msg, http_rcv_buf, &len);
        if ( at_st == 200 ) {
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "HTTP Test", at_st );
            test_st = EMA_TEST_ST_RESET_MEASURE;
            // prep for next test here, as the reset test loops
            test_step++;
        }else{
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "HTTP Test", at_st );
            test_st = EMA_TEST_ST_RESET_MEASURE;
            // prep for next test here, as the reset test loops
            test_step++;
        }

        break;
    case EMA_TEST_ST_RESET_MEASURE:

        // meaure how long of a reset pin low it takes for ema to reset the module
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Reset Time Measure Test(Reset Applied)");
        time_start = TIME_ELAPSED_ms( 0 );
        emaPlay_ema_reset( reset_time );
        cmd_interval = TIME_ELAPSED_ms( 0 );
        test_st = EMA_RESULT_RESET_MEASURE;

        break;
    case EMA_RESULT_RESET_MEASURE:

        // allow time for the URCs
        if (TIME_ELAPSED_ms(cmd_interval) >= 1000) {
            cmd_interval = TIME_ELAPSED_ms( 0 );
            if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_RESET_SHORT ) ) {
                // log the result
                //emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Rst Not observed, URC detected in time(mS)", mgmt_handle->urc_status );
                // go back and measure again
                reset_time += EMA_MODULE_RESET_INCREMENT;
                test_st = EMA_TEST_ST_RESET_MEASURE;
                // clear this flag here
                mgmt_handle->urc_status &= ~MGMT_CNTX_MODULE_RESET_SHORT;
                TIME_DELAY_ms(500);
            }else if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_RESETTING ) ) {
                // the last reset time worked, output it here
                if ( reset_time >= EMA_MODULE_RESET_TIME_LONG ) {
                    emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", reset_time, "Reset observed after limit", mgmt_handle->urc_status );
                    test_st = EMA_TEST_ST_RESET_COMPLETE;
                }else{
                    emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", reset_time, "Reset observed before limit", mgmt_handle->urc_status );
                    test_st = EMA_TEST_ST_FAILED;
                }
            }
        }
        
        break;
    case EMA_TEST_ST_RESET_COMPLETE:

        test_step++;
        emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Reset Complete Test");
        test_st = EMA_RESULT_RESET_COMPLETE;

        break;
    case EMA_RESULT_RESET_COMPLETE:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_RESET ) ) {
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Rst Complete, URC detected in time(mS)", mgmt_handle->urc_status );

            // prep here for next test
            test_step++; 
            cmd_interval = TIME_ELAPSED_ms( 0 );
            time_start = TIME_ELAPSED_ms( 0 );
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "After Reset, Module AT Cmd Test(AT) ");
            test_st = EMA_RESULT_RESET_COMPLETE_CHECK_COMMS;
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_MODULE_READY_FROM_RESET ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_MODULE_READY_FROM_RESET, "Rst Not Complete, URC NOT detected in time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_RESULT_RESET_COMPLETE_CHECK_COMMS:

        // confirm the module is ready by checking comm
        if ( TIME_ELAPSED_ms(time_start) >= EMA_MODULE_AT_READY_MAX_TIME ) {
            // log failure
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_MODULE_AT_READY_MAX_TIME, "After Reset, Max time reached(mS)", at_handle->status );
            test_st = EMA_TEST_ST_FAILED;
        }else{
            if ( TIME_ELAPSED_ms( cmd_interval >= EMA_MODULE_AT_READY_POLLING_INTERVAL ) ) {
                cmd_interval = TIME_ELAPSED_ms( 0 );
                if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_READY ) && ( sts_state == 1 ) ) {
                    at_st = emaModemAT_CheckComm(at_handle);
                    if ( at_st == MOD_AT_ST_SUCCESS ) {
                        // log the result
                        at_handle->status |= MODEM_CNTX_AT_READY;
                        emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "After Reset, Module Ready Time(mS)", at_handle->status );
                        test_st = EMA_TEST_ST_TURN_OFF;
                        //test_st_loop = 1;
                    }
                }
            }
        }

        break;
    case EMA_TEST_ST_TURN_OFF:

        test_step++;
        emaTest_write_test_msg( test_step, u32Sys1msTic, "Turn OFF(pin) Test");
        time_start = TIME_ELAPSED_ms( 0 );
        // dump debug data
        dbg_task( mgmt_handle, at_handle );
        emaPlay_ema_turn_off( );
        test_st = EMA_RESULT_ST_URC_TURN_OFF;

        break;
    case EMA_RESULT_ST_URC_TURN_OFF:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_OFF_GROUP ) ) {
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn OFF, URCs detected in time(mS)", mgmt_handle->urc_status );
            test_st = EMA_RESULT_ST_TURN_OFF_CHECK_COMMS;
            // setup for next test here
            test_step++; 
            // there should be NO module at comms yet, and we already check ema comms in last state
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Module AT Fail Cmd Test(AT)");
            time_start = TIME_ELAPSED_ms( 0 );
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_POWERING_OFF_MAX_TIME ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_POWERING_OFF_MAX_TIME, "Turn OFF(pin), Module Off Time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_RESULT_ST_TURN_OFF_CHECK_COMMS:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_DOWN ) && ( sts_state == 0 ) ) {
            at_st = emaModemAT_CheckComm(at_handle);
            if ( at_st == MOD_AT_ST_SUCCESS) {
                at_handle->status |= MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Module responded(AT)", at_handle->status );
                test_st = EMA_TEST_ST_FAILED;
                break;
            }else{
                at_handle->status &= ~MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Module AT Fail AT cmd(AT)", at_handle->status );
            }

            test_step++; 
            // check comms to ema mcu
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "ema Comms Test(AT)");
            time_start = TIME_ELAPSED_ms( 0 );
            at_st = emaMgmtAT_CheckComm( mgmt_handle );
            if ( at_st == MGMT_AT_ST_SUCCESS) {
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "ema Responded(AT)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_TURN_ON2;
            }else{
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "ema No response(AT)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }


        break;
    case EMA_TEST_ST_TURN_ON2:

        test_step++;
        time_start = TIME_ELAPSED_ms( 0 );
        emaTest_write_test_msg( test_step, time_start, "Turn ON(pin) Test");
        // dump debug data
        dbg_task( mgmt_handle, at_handle );
        emaPlay_ema_turn_on();

        test_st = EMA_RESULT_ST_URCS_TURN_ON2;

        break;
    case EMA_RESULT_ST_URCS_TURN_ON2:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_READY_GROUP ) ) {
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn ON, URCs detected in time(mS)", mgmt_handle->urc_status );

            // prep here for next test
            cmd_interval = TIME_ELAPSED_ms( 0 );
            test_step++; 
            emaTest_write_test_msg( test_step, time_start, "Turn ON(pin), Module AT Cmd Test(AT)");
            test_st = EMA_RESULT_ST_TURN_ON2_CHECK_COMMS;
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_READY_MAX_TIME ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_READY_MAX_TIME, "Turn ON, URCs NOT detected in time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_RESULT_ST_TURN_ON2_CHECK_COMMS:

        // confirm the module is ready by checking comm
        // send an at cmd to the cell module periodically until we get the ok response
        if ( TIME_ELAPSED_ms(time_start) >= EMA_MODULE_AT_READY_MAX_TIME ) {
            // log failure
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_MODULE_AT_READY_MAX_TIME, "Turn ON(pin), Max time reached(mS)", at_handle->status );
            test_st = EMA_TEST_ST_FAILED;
        }else{
            if ( TIME_ELAPSED_ms( cmd_interval >= EMA_MODULE_AT_READY_POLLING_INTERVAL ) ) {
                cmd_interval = TIME_ELAPSED_ms( 0 );
                if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_READY ) && ( sts_state == 1 ) ) {
                    at_st = emaModemAT_CheckComm(at_handle);
                    if ( at_st == MOD_AT_ST_SUCCESS ) {
                        // log the result
                        at_handle->status |= MODEM_CNTX_AT_READY;
                        emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn ON(pin), Module Ready Time(mS)", at_handle->status );
                        test_st = EMA_TEST_ST_TURN_OFF2;
                        //test_st_loop = 1;
                    }
                }
            }
        }

       break;
    case EMA_TEST_ST_TURN_OFF2:

        test_step++;
        emaTest_write_test_msg( test_step, u32Sys1msTic, "Turn OFF(pin) Test");
        time_start = TIME_ELAPSED_ms( 0 );
        emaPlay_ema_turn_off( );
        test_st = EMA_RESULT_ST_URC_TURN_OFF2;

        break;
    case EMA_RESULT_ST_URC_TURN_OFF2:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_OFF_GROUP ) ) {
            // log the result
            emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Turn OFF, URCs detected in time(mS)", mgmt_handle->urc_status );
            test_st = EMA_RESULT_ST_TURN_OFF2_CHECK_COMMS;
            // setup for next test here
            test_step++; 
            // there should be NO module at comms yet, and we already check ema comms in last state
            emaTest_write_test_msg( test_step, (int)u32Sys1msTic, "Module AT Fail Cmd Test(AT)");
            time_start = TIME_ELAPSED_ms( 0 );
        }else{
            if ( TIME_ELAPSED_ms(time_start) >= EMA_POWERING_OFF_MAX_TIME ) {
                // log failure
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", EMA_POWERING_OFF_MAX_TIME, "Turn OFF(pin), Module Off Time(mS)", mgmt_handle->urc_status );
                test_st = EMA_TEST_ST_FAILED;
            }
        }

        break;
    case EMA_RESULT_ST_TURN_OFF2_CHECK_COMMS:

        if ( emaTest_checkURC( mgmt_handle, MGMT_CNTX_MODULE_UART_DOWN ) && ( sts_state == 0 ) ) {
            at_st = emaModemAT_CheckComm(at_handle);
            if ( at_st == MOD_AT_ST_SUCCESS) {
                at_handle->status |= MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:##FAIL##", (int)(u32Sys1msTic - time_start), "Module responded(AT)", at_handle->status );
                test_st = EMA_TEST_ST_FAILED;
                break;
            }else{
                at_handle->status &= ~MODEM_CNTX_AT_READY;
                emaTest_write_test_result( test_step, (int)u32Sys1msTic, "RESULT:PASS", (int)(u32Sys1msTic - time_start), "Module AT Fail AT cmd(AT)", at_handle->status );
                test_st = EMA_TEST_ST_REMOVE_POWER;
            }
        }

        break;
    case EMA_TEST_ST_REMOVE_POWER:

        //test_step++;
        //emaTest_write_test_msg( test_step, u32Sys1msTic, "Remove Power Test");
        //time_start = TIME_ELAPSED_ms( 0 );
        emaPlay_ema_remove_power( );

        test_st = EMA_TEST_ST_SUMMARY;

        break;
    case EMA_RESULT_ST_REMOVE_POWER_CHECK_COMMS:

        test_st = EMA_TEST_ST_SUMMARY;

        break;
    case EMA_TEST_ST_FAILED:

        test_st = EMA_TEST_ST_SUMMARY;

        break;
    case EMA_TEST_ST_SUMMARY:
        // purge any debug data in the q from the last test
        dbg_task( mgmt_handle, at_handle );

        // print the validation test summary
        emaPlay_dbg_uart_send( "\r\n\r\n\r\n****** ema Validation Test Summary ******\r\n\r\n", 51, 50, 0 );
        l = sprintf( str, "SN: %s\r\nFW: %s\r\n\r\n", sn, fw );
        emaPlay_dbg_uart_send( str, l, 50, 0 );
        emaPlay_dbg_uart_send( "Test#   Pass/Fail           Desc.                                 Start Time   End Time   Result   Data\r\n", 105, 50, 0 );
        emaPlay_dbg_uart_send( "-------------------------------------------------------------------------------------------------------\r\n", 105, 50, 0 );

        // output all of the summary info
        for ( at_st=0; at_st <= test_step; at_st++ ) {
            if ( summary[at_st].test_step[0] != 0 ) {
                emaPlay_dbg_uart_send(summary[at_st].test_step, summary[at_st].test_step_length, 50, 0);
                // line up data on screen
                col = 8;
                for ( i=0; i< (col - summary[at_st].test_step_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send( summary[at_st].str_result, summary[at_st].str_result_length, 50, 0 );
                col = 20;
                for ( i=0; i< (col - summary[at_st].str_result_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send( summary[at_st].test_name, summary[at_st].test_name_length, 50 ,0 );
                col = 38;
                for ( i=0; i< (col - summary[at_st].test_name_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send( summary[at_st].start_time, summary[at_st].start_time_length, 50, 0 );
                col = 13;
                for ( i=0; i< (col - summary[at_st].start_time_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send(summary[at_st].end_time, summary[at_st].end_time_length, 50, 0);
                col = 11;
                for ( i=0; i< (col - summary[at_st].end_time_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send(summary[at_st].result, summary[at_st].result_length, 50, 0);
                col = 9;
                for ( i=0; i< (col - summary[at_st].result_length); i++  ) {
                    emaPlay_dbg_uart_send(" ", 1, 50, 0);
                }
                emaPlay_dbg_uart_send(summary[at_st].verbose_data, summary[at_st].verbose_data_length, 50, 0);
                emaPlay_dbg_uart_send( "\r\n", 2, 50 ,0 );
            }
        }

        emaPlay_dbg_uart_send( "\r\n****** ema Validation Test Complete ******\r\n", 46, 50, 0 );

        test_st = EMA_TEST_ST_COMPLETE;
        break;
    case EMA_TEST_ST_COMPLETE:

        test_st = EMA_TEST_IDLE;                       
        ema_at_test_st = EMA_AT_TEST_ST_LIST_CMDS;     

        break;
    }
}

void emaTest_write_test_result( int sum_idx, int timestamp, char *event, int result, char *verbose_data, unsigned short data  )
{
    char str[256];
    int l;

    l = sprintf(str, "\r\n%d, %s, Val=%d, %s, %#.2x\r\n---TEST END---\r\n\r\n", timestamp, event, result, verbose_data, data );
    emaPlay_dbg_out( str, l );

    // save the data for the summary output
    summary[sum_idx].end_time_length = sprintf(summary[sum_idx].end_time, "%d", timestamp);
    summary[sum_idx].result_length = sprintf(summary[sum_idx].result, "%d", result);
    summary[sum_idx].str_result_length = sprintf(summary[sum_idx].str_result, "%s", event);
    summary[sum_idx].verbose_data_length = sprintf(summary[sum_idx].verbose_data, "%s", verbose_data);
}

void emaTest_write_test_result_str( int sum_idx, int timestamp, char *event, int result, char *verbose_data, char *result_str  )
{
    char str[256];
    int l;

    l = sprintf(str, "\r\n%d, %s, Val=%d, %s, %s\r\n---TEST END---\r\n\r\n", timestamp, event, result, verbose_data, result_str );
    emaPlay_dbg_out( str, l );

    // save the data for the summary output
    summary[sum_idx].end_time_length = sprintf(summary[sum_idx].end_time, "%d", timestamp);
    summary[sum_idx].result_length = sprintf(summary[sum_idx].result, "%d", result);
    summary[sum_idx].str_result_length = sprintf(summary[sum_idx].str_result, "%s", event);
    summary[sum_idx].verbose_data_length = sprintf(summary[sum_idx].verbose_data, "%s", result_str);
}

void emaTest_write_test_msg( int sum_idx, int timestamp, char *msg )
{
    char str[128];
    int l;

    l = sprintf(str, "\r\n\r\n---TEST START---\r\n%d, %s", timestamp, msg );
    emaPlay_dbg_out( str, l );

    // save the data for the summary output
    summary[sum_idx].test_step_length = sprintf( summary[sum_idx].test_step, "%d", sum_idx );
    summary[sum_idx].test_name_length = sprintf(summary[sum_idx].test_name, "%s", msg);
    summary[sum_idx].start_time_length = sprintf(summary[sum_idx].start_time, "%d", timestamp);
}

uint8_t emaTest_checkURC( struct ema_mgmt_context *mgmt_handle, unsigned long URCMask )
{
    uint8_t ret = 0;

    // check the urc status against the mask
    if ( (mgmt_handle->urc_status & URCMask) == URCMask ) {
        ret = 1;
    }

    return ret;
}

